/****** Object:  View [dbo].[V_BI_EST_PROD]    Script Date: 04/11/2013 10:05:53 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_BI_EST_PROD]'))
DROP VIEW [dbo].[V_BI_EST_PROD]
GO
CREATE VIEW V_BI_EST_PROD AS
SELECT      
	EST_PROD.CD_PROD AS Produto, 
	EST_PROD.DS_PROD as Descricao, 
	EST_PROD_FABRIC.CD_FABRIC as CdFabricante,
	EST_PROD_FABRIC.NM_FABRIC as NomeFabricante, 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA as CdLinha,	
	EST_ARV_MERC_LINHA.DS_ARV_MERC_LINHA as Linha, 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_FAMILIA AS CdFamilia,
	EST_ARV_MERC_FAMILIA.DS_ARV_MERC_FAMILIA as Familia,
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_CATEG as CdCategoria,
	EST_ARV_MERC_CATEGORIA.DS_ARV_MERC_CATEG as Categoria, 
	EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_DEPTO as CdDepartamento,
	EST_ARV_MERC_DEPTO.DS_ARV_MERC_DEPTO as Departamento, 
	EST_ARV_MERC_AREA_ATENDIMENTO.CD_ARV_MERC_AREA_ATEND as CdAreaAtendimento,	
    EST_ARV_MERC_AREA_ATENDIMENTO.DS_ARV_MERC_AREA_ATEND as AreaAtendimento,
	EST_ARV_MERC_SEGMENTO.DS_ARV_MERC_SEG as Segmento,
	EST_PROD.FLAG_ANALISE_EXC_COB AS FlagAnaliseExCobProd,
	EST_PROD.FLAG_ANALISE_FALTAS AS FlagAnaliseFaltasProd,
	EST_PROD.STS_PROD AS StsProd,
	EST_PROD.COMPRA_POR_SUPRIMENTO as TipoCompra,
	EST_ARV_MERC_LINHA.FLAG_NAO_PARTIC_INDIC AS FlagNaoPartIndicadoresLinha
FROM            
	EST_PROD INNER JOIN EST_PROD_FABRIC ON 
	EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC INNER JOIN
    EST_PROD_EST_ARV_MERCADOLOGICA ON EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND 
	EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	INNER JOIN EST_ARV_MERC_FAMILIA ON 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_ARV_MERC_FAMILIA.CD_EMP AND 
    EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_FAMILIA = EST_ARV_MERC_FAMILIA.CD_ARV_MERC_FAMILIA 
	INNER JOIN EST_ARV_MERC_LINHA ON 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA AND 
    EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP 
	INNER JOIN EST_ARV_MERC_CATEGORIA ON 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_ARV_MERC_CATEGORIA.CD_EMP AND 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_CATEG = EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG 
	INNER JOIN EST_ARV_MERC_DEPTO ON 
	EST_ARV_MERC_CATEGORIA.CD_EMP = EST_ARV_MERC_DEPTO.CD_EMP AND 
    EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_DEPTO = EST_ARV_MERC_DEPTO.CD_ARV_MERC_DEPTO 
	INNER JOIN EST_ARV_MERC_AREA_ATENDIMENTO ON 
	EST_ARV_MERC_DEPTO.CD_EMP = EST_ARV_MERC_AREA_ATENDIMENTO.CD_EMP AND 
    EST_ARV_MERC_DEPTO.CD_ARV_MERC_AREA_ATEND = EST_ARV_MERC_AREA_ATENDIMENTO.CD_ARV_MERC_AREA_ATEND
	INNER JOIN EST_ARV_MERC_SEGMENTO ON 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_ARV_MERC_SEGMENTO.CD_EMP AND 
    EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_SEG = EST_ARV_MERC_SEGMENTO.CD_ARV_MERC_SEG
UNION ALL
SELECT      
	0 AS Produto, 
	'RECARGA' as Descricao, 
	0 as CdFabricante,
	'DIVERSOS' as NomeFabricante, 
	0 as CdLinha,
	'SERVICO' as Linha, 
	0 as CdFamilia,
	'SERVICO' as Familia, 
	0 as CdCategoria,
	'RECARGA' as Categoria, 
	0 as CdDepartamento,
	'RECARGA' as Departamento, 
    0 as CdAreaAtendimento,
	'SERVICO' as AreaAtendimento,
	'SERVICO' as Segmento,
	1 AS FlagAnaliseExCobProd,
	1 AS FlagAnaliseFaltasProd,
	0 AS StsProd,
	0 as TipoCompra,
	1 AS FlagNaoPartIndicadoresLinha

